using System;
using System.ComponentModel.Composition;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VIMT.VideoVisit.Messages;
using VIMT.VideoVisit.Processors;

namespace VIMT.VideoVisit.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VIMTTmpUpdateAppointmentRequest)]
    /// <summary>
    /// VIMT Enterprise Component for VIMT.VirtualMeetingRoom,ScheduleMeeting method, MessageHandler.
    /// Code Generated by IMS on: 4/12/2016 6:51:29 PM
    /// Version: 2016.04.08
    /// </summary>
    /// <param name=none></param>
    /// <returns>none</returns>
    public class VIMTTmpUpdateAppointmentMessageHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                LogMessageReceipt(message);
                var processor = new VIMTTmpUpdateAppointmentProcessor();
                return processor.Execute((VIMTTmpUpdateAppointmentRequest)message);
            }
            catch (Exception ex)
            {
                VIMTTmpUpdateAppointmentRequest msg = (VIMTTmpUpdateAppointmentRequest)message;
                LogHelper.LogError(msg.OrganizationName, msg.UserId, "VIMTTmpUpdateAppointmentRequest.HandleRequestResponse", ex);
                throw new Exception(string.Format("VIMTTmpUpdateAppointmentRequest Error: {0}", ex.Message), ex);
            }
        }
    }
}
